.TH MFT 1 "7 January 2026" "Web2C @VERSION@"
.\"=====================================================================
.if n .ds MP MetaPost
.if t .ds MP MetaPost
.if n .ds MF Metafont
.if t .ds MF Metafont
.if t .ds TX \fRT\\h'-0.10m'\\v'0.17v'E\\v'-0.17v'\\h'-0.06m'X\fP
.if n .ds TX TeX
.\"=====================================================================
.SH NAME
mft \- translate Metafont or MetaPost code to TeX for prettyprinting
.SH SYNOPSIS
.B mft
.RI [ options ]
.BR \fIsource_file\fP [ .mf | .mp ]
.\"=====================================================================
.SH DESCRIPTION
The
.B mft
program creates a \*(TX file from a \*(MF or \*(MP program.
It takes appropriate care of typographic details like page
layout and the use of indentation, italics, boldface, etc., as illustrated
in the book \fIComputer Modern Typefaces\fP by Donald Knuth.
.PP
Special conventions in \*(MF and \*(MP comments allow you to control
things that would not otherwise come out right; section 1 of the
\fBmft\fP source program and the mft section in the Web2C manual
explain these rules.
.PP
The
.B mft
program uses an optional change file (which works just as the change files to
.BR tangle (1)
and
.BR weave (1)
do)
and one or several style files (which are prepended to everything).
If no style file is specified, the style file
.B plain.mft
for \*(MF, or
.B mplain.mft
for \*(MP, is used.  These files are specified via the options below.
.PP
The \fIsource_file\fP, as well as any change and style files, are
searched for using the MFINPUTS (for \*(MF) or MPINPUTS (for \*(MP) and
MFTINPUTS environment variables if you have set them, or else the
corresponding system defaults.
.PP
The output \*(TX file name is formed by using
.B .tex
in place of the extension of
.IR source_file .
.\"=====================================================================
.SH OPTIONS
See
.BR tex (1)
for details of command-line parsing.
.TP
.BI -change= change_file \fR[\fP.ch\fR]\fP
Apply the change file
.I change_file
to
.IR mf_file .
.PP
.TP
.B -metapost
Consider
.I source_file
to be a \*(MP source file; this is the default if
.I mf_file
has the extension
.BR .mp .
.PP
.TP
.BI -style= style_file \fR[\fP.mft\fR]\fP
Use the style file
.I style_file
instead of
.B plain.mft
or
.BR mplain.mft ;
this option can be given more than once.
.PP
The standard
.B -help
and
.B -version
options are also supported.
.\"=====================================================================
.SH FILES
.TP
.I mftmac.tex\fR,\fP mptmac.tex
\*(TX macros used by the output from \fBmft\fP for Metafont and
MetaPost input, respectively.
.TP
.IR plain.mft ", " mplain.mft
Default style files.
.TP
.I cmbase.mft
Style file for Computer Modern.
.TP
.I e.mft
Style file for Knuth's Volume E: Computer Modern Typefaces.
.\"=====================================================================
.SH "SEE ALSO"
.BR mf (1),
.BR mpost (1),
.BR weave (1).
.br
Donald E. Knuth,
.I Computer Modern Typefaces
(Volume E of
.IR "Computers & Typesetting" ).
.br
Donald E. Knuth et al.,
.IR \*(MFware .
.PP
Package page on CTAN: https://ctan.org/pkg/mft
.br
Section in the Web2c manual:
https://tug.org/texinfohtml/web2c.html#mft-invocation
.br
Typeset source code, including the typesetting controls:
https://ctan.org/pkg/knuth-pdf
.\"=====================================================================
.SH AUTHORS
Donald E. Knuth wrote and still maintains the program. He ported it to
Unix with the help of Pierre MacKay and the Unix port of
.B weave
by Howard Trickey and Pavel Curtis.
.PP
Public discussion list and bug reports: https://lists.tug.org/tex-k
