.TH PKTOGF 1 "25 January 2026" "Web2C @VERSION@"
.\"=====================================================================
.if n .ds MF Metafont
.if t .ds MF Metafont
.if t .ds TX \fRT\\h'-0.10m'\\v'0.17v'E\\v'-0.17v'\\h'-0.06m'X\fP
.if n .ds TX TeX
.\"=====================================================================
.SH NAME
pktogf \- convert packed font files to generic font files (both bitmaps)
.SH SYNOPSIS
.B pktogf
.RB [ -v ]
.I pk_file
.RI [ gf_file ]
.\"=====================================================================
.SH DESCRIPTION
The
.B pktogf
program converts a packed font bitmap file
.RI ( pk )
to a generic font bitmap file
.RI ( gf ).
Packed
font files are much smaller than the corresponding
.I gf
files, but you may want to convert to \fIgf\fP in order to use
.BR gftype (1)
and
.BR gftodvi (1)
utility programs.
.PP
The
.I pk_file
on the command line must include the resolution, but can omit the suffix
"pk". The
.I gf_file
defaults to the same base name as
.IR pk_file ,
and it is placed in the current
working directory with the
.B gf
suffix replacing
.BR pk .
For example, the input file
.I /some/directory/io.300pk
would become
.IR io.300gf .
.\"=====================================================================
.SH OPTIONS
See
.BR tex (1)
for details of command-line parsing.
By default,
.B pktogf
operates silently.  With the \fB-v\fP (a.k.a\&. \fB-verbose\fP) option,
the version number of the program and statistics about the
unpacking are output to stdout.
.PP
The standard
.B -help
and
.B -version
options are also supported.
.\"=====================================================================
.SH ENVIRONMENT
The program looks for
.I pk_file
using the environment variables PKFONTS, TEXPKS, GLYPHFONTS, and
TEXFONTS, in that order. If none are set, it uses the system default.
See the Kpathsea manual at https://tug.org/kpathsea for the details of
the searching.
.\"=====================================================================
.SH "SEE ALSO"
.BR gftodvi (1),
.BR gftopk (1),
.BR gftype (1),
.BR pktype (1).
.br
Donald E. Knuth et al.,
.IR \*(MFware .
.PP
Package page on CTAN: https://ctan.org/pkg/pktogf
.br
Section in the Web2c manual:
https://tug.org/texinfohtml/web2c.html#pktogf-invocation
.br
Typeset source code, including file format descriptions:
https://ctan.org/pkg/knuth-pdf
.\"=====================================================================
.SH AUTHORS
Tomas Rokicki wrote the program.
Pierre MacKay adapted it for compilation with web2c.
.PP
Public discussion list and bug reports: https://lists.tug.org/tex-k
